/*
 * Decompiled with CFR 0.152.
 */
package com.starmicronics.utility;

import com.starmicronics.utility.BaseTextMagnification;
import com.starmicronics.utility.PrintResolution;
import jpos.config.JposEntry;

public class ParsedJposEntry {
    private PrintResolution m_printResolution = PrintResolution.ResolutionNotSpecified;
    private BaseTextMagnification m_baseTextMagnification = BaseTextMagnification.NotSupported;
    private boolean m_isSupportMarkFeed = false;

    public ParsedJposEntry(JposEntry jposEntry) {
        if (jposEntry.hasPropertyWithName("printResolution") && String.class == jposEntry.getPropertyType("printResolution") && jposEntry.getPropertyValue("printResolution").toString().equals("300")) {
            this.m_printResolution = PrintResolution.Resolution300dpi;
        }
        if (this.m_printResolution == PrintResolution.Resolution300dpi && jposEntry.hasPropertyWithName("baseTextMagnification") && String.class == jposEntry.getPropertyType("baseTextMagnification")) {
            String string = jposEntry.getPropertyValue("baseTextMagnification").toString();
            if (string.equals("x1_5")) {
                this.m_baseTextMagnification = BaseTextMagnification.X1_5;
            } else if (string.equals("standard")) {
                this.m_baseTextMagnification = BaseTextMagnification.Standard;
            }
        }
        if (jposEntry.hasPropertyWithName("supportMarkFeed") && Boolean.class == jposEntry.getPropertyType("supportMarkFeed")) {
            this.m_isSupportMarkFeed = (Boolean)jposEntry.getPropertyValue("supportMarkFeed");
        }
    }

    public PrintResolution getPrintResolution() {
        return this.m_printResolution;
    }

    public BaseTextMagnification getBaseTextMagnification() {
        return this.m_baseTextMagnification;
    }

    public boolean isSupportMarkFeed() {
        return this.m_isSupportMarkFeed;
    }
}

